/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.humanoid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByRace;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.jobs.model.Profession;

public class HumanoidEntityAssetsByType {
    private Map<EntityAssetType, HumanoidEntityAssetsByRace> typeMap = new HashMap<EntityAssetType, HumanoidEntityAssetsByRace>();

    public HumanoidEntityAssetsByType(EntityAssetTypeDictionary typeDictionary) {
        for (EntityAssetType assetType : typeDictionary.getAll()) {
            this.typeMap.put(assetType, new HumanoidEntityAssetsByRace());
        }
    }

    public void add(HumanoidEntityAsset asset) {
        this.typeMap.get(asset.getType()).add(asset);
    }

    public HumanoidEntityAsset get(EntityAssetType type, HumanoidEntityAttributes attributes, Profession primaryProfession) {
        return this.typeMap.get(type).get(attributes, primaryProfession);
    }

    public List<HumanoidEntityAsset> getAll(EntityAssetType type, HumanoidEntityAttributes attributes, Profession primaryProfession) {
        return this.typeMap.get(type).getAll(attributes, primaryProfession);
    }
}

